/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.util;

import cn.com.duiba.kjy.api.enums.renew.VipCycleEnum;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SellerVipCycleUtil {
    private static final Logger log = LoggerFactory.getLogger(SellerVipCycleUtil.class);

    public static VipCycleEnum calculateVipCycle(LocalDateTime now, Date vipEndTime) {
        if (Objects.isNull(now) || Objects.isNull(vipEndTime)) {
            return null;
        }
        if (Date.from(now.plusDays(VipCycleEnum.CYCLE_THIRTY_FIFTEEN.getCode().intValue()).atZone(ZoneId.systemDefault()).toInstant()).before(vipEndTime)) {
            return null;
        }
        if (Date.from(now.plusDays(VipCycleEnum.CYCLE_FIFTEEN_TODAY.getCode().intValue()).atZone(ZoneId.systemDefault()).toInstant()).before(vipEndTime)) {
            return VipCycleEnum.CYCLE_THIRTY_FIFTEEN;
        }
        if (Date.from(now.plusDays(VipCycleEnum.CYCLE_TODAY.getCode().intValue()).atZone(ZoneId.systemDefault()).toInstant()).before(vipEndTime)) {
            return VipCycleEnum.CYCLE_FIFTEEN_TODAY;
        }
        if (Date.from(now.atZone(ZoneId.systemDefault()).toInstant()).before(vipEndTime)) {
            return VipCycleEnum.CYCLE_TODAY;
        }
        if (Date.from(now.plusDays(VipCycleEnum.EXPIRED_THREE_DAYS.getCode().intValue()).atZone(ZoneId.systemDefault()).toInstant()).before(vipEndTime)) {
            return VipCycleEnum.EXPIRED_THREE_DAYS;
        }
        if (Date.from(now.plusDays(VipCycleEnum.EXPIRED_FIFTEEN_DAYS.getCode().intValue()).atZone(ZoneId.systemDefault()).toInstant()).before(vipEndTime)) {
            return VipCycleEnum.EXPIRED_FIFTEEN_DAYS;
        }
        return null;
    }
}

