package cn.com.duiba.kjy.api.bean.clue;

import lombok.Data;
import org.jetbrains.annotations.NotNull;

import java.io.Serializable;
import java.util.Map;

/**
 * 线索mq消息体
 *
 * @author xuzhigang
 * @date 2021/12/15 5:07 下午
 **/
@Data
public class SellerVisitClueMqBean implements Serializable {
    private static final long serialVersionUID = -6406648422289715817L;
    /**
     * 销售员内容id
     */
    @NotNull
    private Long scid;

    /**
     * 销售id
     */
    @NotNull
    private Long sellerId;

    /**
     * 访客id
     */
    @NotNull
    private Long visitorId;

    /**
     * 用户访问记录id
     */
    @NotNull
    private Long userVisitId;

    /**
     * 业务id
     */
    @NotNull
    private Long clueBizId;

    /**
     * 线索业务类型
     * {@link cn.com.duiba.kjy.api.enums.clue.ClueBizTypeEnum}
     */
    private Integer clueBizType;

    /**
     * 来源scid
     */
    private Long sourceScid;

    /**
     * key: {@link cn.com.duiba.kjy.api.enums.clue.ClueExtNameEnum}
     * value: 扩展字段
     */
    private Map<Integer, String> extMap;
}
