package cn.com.duiba.kjy.api.dto.chinalife;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 报名系统报名客户表
 * @author kjj mybatis generator
 * 2021-04-17
 */
@Data
public class ChinaLifeCustomerDto implements Serializable {
    private static final long serialVersionUID = 16186281476923417L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *日程ID
     * not null default = null
     */
    private Long scheduleId;
    /**
     * 营业部
     */
    private String department;

    /**
     *
     *公司ID
     * not null default = null
     */
    private Long companyId;

    /**
     *
     *使用掉的数量
     * max length = 20
     * not null default = 0
     */
    private String customName;

    /**
     *
     *0:男 1:女
     * not null default = 0
     */
    private Boolean customSex;

    /**
     *
     *年龄
     * not null default = null
     */
    private Integer customAge;

    /**
     *
     *身份证
     * max length = 64
     * not null default = null
     */
    private String customIdCard;

    /**
     *
     *客户手机号
     * max length = 255
     * not null default = null
     */
    private String customPhone;

    /**
     *
     *1:伙伴 2:伙伴家属 3:客户 4:客户家属 5:客户朋友 6:营管
     * not null default = null
     */
    private Byte customType;

    /**
     *
     *伙伴姓名
     * max length = 50
     * not null default = null
     */
    private String agentName;

    /**
     *
     *伙伴工号
     * max length = 50
     * not null default = null
     */
    private String agentJobNum;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}
