package cn.com.duiba.kjy.api.enums;

import cn.com.duiba.kjy.api.constant.ContentTypeEnum;
import org.apache.commons.lang3.StringUtils;

/**
 * 导入素材分类
 *
 * Created by hong
 * time 2019/12/6 17:39.
 */
public enum ImportTypeEnum {
    ARTICLE("1", "文章导入"),
    URL("2", "全网链接导入"),
    VIDEO("3", "全网视频导入"),
    ;

    ImportTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    private String code;
    private String desc;

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getContentTypeEnum(Integer type){
        if(StringUtils.equals(ImportTypeEnum.ARTICLE.getCode(),type.toString())){
            return ContentTypeEnum.ARTICLE.getCode();
        }else if(StringUtils.equals(ImportTypeEnum.URL.getCode(),type.toString())){
            return ContentTypeEnum.NETWORK_LINK.getCode();
        }else if(StringUtils.equals(ImportTypeEnum.VIDEO.getCode(),type.toString())){
            return ContentTypeEnum.VIDEO.getCode();
        }
        return null;
    }
}
