package cn.com.duiba.kjy.api.enums.custmaketing;

import java.util.Objects;

/**
 * 小程序 客户营销页  顶部模块
 * @author 吴文哲
 * @date 2019-12-18 16:34
 **/
public enum CustMarketingTopEntryEnum {
    LOTTERY_GAME(1,"抽奖工具"),
    FRIEND_FISSION(2,"好友裂变"),
    CONGRATULATION_CARD(3,"心意贺卡"),
    ;
    private int type ;

    private String desc;

    CustMarketingTopEntryEnum(int type,String desc){
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static CustMarketingTopEntryEnum getByType(Integer code) {
        if (Objects.isNull(code)){
            return null;
        }
        for (CustMarketingTopEntryEnum enumVal : CustMarketingTopEntryEnum.values()) {
            if (Objects.equals(enumVal.getType(),code)) {
                return enumVal;
            }
        }
        return null;
    }
}
