package cn.com.duiba.kjy.api.params.corp;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 活动分页查询参数
 *
 * @author ZhangJun
 * @date 2021/11/4 10:08 上午
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ActivityEsPageListParam extends PageQuery {

    private static final long serialVersionUID = 6614052625649528389L;

    /**
     * 公司id
     * ES筛选指定公司的活动
     */
    private Long companyId;

    /**
     * 营业部id
     * ES筛选指定营业部的活动
     */
    private Long deptId;

    /**
     * 活动状态，1-未开始，2-进行中，3-已结束
     * ES筛选不为该状态的活动
     */
    private Integer activityState;

}
