package cn.com.duiba.kjy.api.remoteservice.appvideo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.appvideo.AppVideoVersionDto;

import java.util.List;

/**
 * @author likui
 * @date 2021/10/11 11:31 上午
 * 跟拍app版本rpc
 **/
@AdvancedFeignClient
public interface RemoteAppVideoVersionApiService {

    /**
     * 获取最新跟拍app最新版本信息
     * @param platform 安装包所属平台1:IOS,2:安卓
     * @return app最新版本信息
     */
    List<AppVideoVersionDto> getLatestVersionByCurrent(Integer platform);

    /**
     * 新增版本信息
     * @param versionEntity 版本实体类
     * @return 新增结果
     */
    Long insert(AppVideoVersionDto versionEntity);

    /**
     * 根据分页查询版本信息
     * @param offset 偏移量
     * @param pageSize 每页条数
     * @return 版本信息
     */
    List<AppVideoVersionDto> list(Integer offset,Integer pageSize);

    /**
     * 查询记录条数
     * @return 记录条数
     */
    Integer selectCount();

    /**
     * 根据平台和版本查询版本信息
     * @param version 版本
     * @param platform 平台
     * @return 版本信息
     */
    AppVideoVersionDto selectByVersionAndPlatform(String version, Integer platform);

    /**
     * 物理删除
     * @param id 主键值
     * @return 删除结果
     */
    Integer delete(Long id);

    /**
     * 根据ID查询版本信息
     * @param id 主键值
     * @return 版本信息
     */
    AppVideoVersionDto selectOne(Long id);

    /**
     * 根据ID更新状态
     * @param id 主键值
     * @param state 要更新的状态
     * @return 更新结果
     */
    int updateState(Long id, Integer state);
}
