package cn.com.duiba.kjy.api.remoteservice.push;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.push.SellerPushDataDto;

import java.util.List;

/**
 * 代理人推送数据rpc
 *
 * @author xuzhigang
 * @date 2021/03/30 3:46 下午
 **/
@AdvancedFeignClient
public interface RemoteSellerPushDataService {

    /**
     * 根据代理人id查询
     * @param sellerId 代理人id
     * @return 代理人推送数据
     */
    SellerPushDataDto getBySid(Long sellerId);

    /**
     * 根据代理人id列表查询
     * @param sellerIds 代理人id列表
     * @return 推送数据列表
     */
    List<SellerPushDataDto> listBySids(List<Long> sellerIds);
}
