package cn.com.duiba.kjy.api.constant;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * 支付订单状态枚举
 * @author zhangshun
 * @date 2019/2/20
 */
public enum SellerPayStatusEnum implements Serializable {

    WAIT(1, "待付款"),
    IN_PAY(2, "付款中"),
    SUCCEED(3, "付款成功"),
    FAILED(4, "付款失败"),
    CANCELED(5, "取消支付"),
    EXCEPTION(6, "支付异常"),
    ALL_REFUND(7, "全额退款"),

    ;

    private Integer code;
    private String desc;

    // 订单最终态（不可变状态）集合
    public static final List<Integer> immutableStatusList = Arrays.asList(ALL_REFUND.code,FAILED.code,CANCELED.code,EXCEPTION.code);

    SellerPayStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static String getDescOfCode(Integer code){
        for (SellerPayStatusEnum e :values()){
            if (Objects.equals(code, e.getCode())) {
                return e.getDesc();
            }
        }
        throw new UnsupportedOperationException("不支持的支付状态");

    }
}
