package cn.com.duiba.kjy.api.dto.feedback;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 代理人意见反馈表
 *
 * @author kjj mybatis generator
 * 2021-07-13
 */
@Data
public class SellerFeedbackDto implements Serializable {
    private static final long serialVersionUID = 1626144413117511L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * 反馈内容
     */
    private String feedbackContent;

    /**
     * 反馈图片，以英文逗号分割
     */
    private String feedbackPics;

    /**
     * 反馈类型 1-功能异常 2-体验问题 3-新功能建议 4-其他
     * @see cn.com.duiba.kjy.api.enums.feedback.FeedbackTypeEnum
     */
    private Integer feedbackType;

    /**
     * 反馈页面入口 1-客服消息 2-首页机器人 3-个人中心
     * @see cn.com.duiba.kjy.api.enums.explosioncontent.FaqClueSourceTypeEnum
     */
    private Integer feedbackSource;

    /**
     * 反馈时间
     */
    private Date gmtCreate;
}