package cn.com.duiba.kjy.api.dto.weeklystats;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 代理人周报客户产生线索统计
 * @author kjj mybatis generator 
 * 2020-07-13
 */
@Data
public class WeeklyCustomerClueStatsDto implements Serializable {
    private static final long serialVersionUID = 15946077242672054L;

    /**
     *
     *主键ID
     * not null default = null
     */
    private Long id;

    /**
     *
     *销售id，对应tb_sellers.id
     * not null default = null
     */
    private Long sellerId;

    /**
     *
     *周开始时间
     * not null default = null
     */
    private Date startDate;

    /**
     *
     *周结束时间
     * not null default = null
     */
    private Date endDate;

    /**
     *
     *客户id，tb_users.id
     * not null default = null
     */
    private Long userId;

    /**
     *
     *总线索数
     * not null default = 0
     */
    private Integer clueCount;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}