package cn.com.duiba.kjy.api.enums;

import java.util.Objects;

/**
 * @author lizhi
 * @date 2019-06-05
 */
public enum  ContentSellerImportEnum {

    //1=销售员上传，0=非销售员上传
    SELLER_IMPORT(1, "销售员上传"),
    NON_SELLER_IMPORT(0, "非销售员上传"),
    ;
    private int code;

    private String desc;

    ContentSellerImportEnum(int code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static ContentSellerImportEnum getByCode(int code) {
        for (ContentSellerImportEnum enumVal : ContentSellerImportEnum.values()) {
            if (enumVal.getCode()==code) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(int code) {
        ContentSellerImportEnum byCode = getByCode(code);
        if (Objects.isNull(byCode)) {
            return "";
        }
        return byCode.getDesc();
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
