package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.vip.PromotionCodeDto;
import cn.com.duiba.kjy.api.params.PromotionCodeParam;

import java.util.List;

/**
 * Created by dugq on 2019-05-25.
 */
@AdvancedFeignClient
public interface RemotePromotionCodeService {

    /**
     * 根据参数查询激活码列表
     * @param pojo
     * @return
     */
    List<PromotionCodeDto> selectList(PromotionCodeParam pojo);

    /**
     * 根据批次id，查询付费成功的销售id列表
     * @param batchId
     * @return
     */
    List<Long> findByBatchId(Long batchId);

    int update(PromotionCodeDto record);

    Integer selectCount(PromotionCodeParam pojo);

    @Deprecated
    /**
     * 加锁的时候就关联上用户信息，此方法废弃
     */
    int lock(String code);

    /**
     * 锁住优惠码，同时标记出是谁锁定的
     * @param code
     * @param userId
     * @param sellerId
     * @return
     */
    int lockAndBindSeller(String code,Long userId,Long sellerId);

    /**
     * 解锁优惠码
     * @param code
     * @return
     */
    int unlock(String code);

    /**
     * 订单成功，优惠码实效
     * @param code
     * @return
     */
    int used(String code);

    PromotionCodeDto selectByCode(String code);

    /**
     * 在指定批次中，为用户分配一个未使用的优惠码
     * @param batchId
     * @param sellerId
     * @return
     */
    @Deprecated
    /**
     * 和下面一个方法效果相同，userID查询改为传入
     */
    String getOneNotUsedPromotionCodeAndLock(Long batchId,Long sellerId);

    /**
     * 在指定批次中，为用户分配一个未使用的优惠码 并绑定用户
     * @param batchId
     * @param sellerId
     * @return
     */
    String selectOneNotUsedAndLockThisRecord(Long batchId, Long sellerId, Long userId);

    /**
     * userId,sellerId 任选一个即可
     * 查询出用户最近一次锁定的优惠码一个
     * @param userId
     * @param sellerId
     * @return
     */
    PromotionCodeDto selectUserLockingPromotionCode(Long userId,Long sellerId);

    List<PromotionCodeDto> findByPromotionCode(List<String> promotionCode);

    /**
     * 通过批次号id和销售id查询优惠码
     *
     * @param batchId  批次id
     * @param sellerId 销售id
     * @return 优惠码
     */
    List<String> findByBatchIdAndSellerId(Long batchId, Long sellerId);
}
