package cn.com.duiba.kjy.api.remoteservice.feedback;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.feedback.SellerFeedbackDto;
import cn.com.duiba.kjy.api.params.PageQuery;
import cn.com.duiba.kjy.api.params.feedback.SellerFeedbackParam;

import java.util.List;

/**
 * 代理人反馈rpc
 *
 * @author xuzhigang
 * @date 2021/7/13 3:24 下午
 **/
@AdvancedFeignClient
public interface RemoteSellerFeedbackService {
    /**
     * 分页查询
     * 管理后台专用
     *
     * @param param 查询参数
     * @param pageQuery 分页参数
     * @return 反馈信息
     */
    List<SellerFeedbackDto> selectPage(SellerFeedbackParam param, PageQuery pageQuery);

    /**
     * 根据条件查询记录的总记录数
     * 管理后台专用
     *
     * @param param 查询参数
     * @return 数量
     */
    Long selectCount(SellerFeedbackParam param);

    /**
     * 插入
     * @param dto 反馈数据
     * @return 执行结果
     */
    int insert(SellerFeedbackDto dto);
}
