package cn.com.duiba.kjy.api.dto.bank.direct.red;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhuenhui
 * @date 2021/12/21 14:29
 * @description 银行个金 - 直接发红包 Dto
 */
@Data
public class DirectRedRecordDto implements Serializable {

    private static final long serialVersionUID = 5650319606948233017L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 客户姓名
     */
    private String customerName;

    /**
     * 公司Id
     */
    private Long companyId;

    /**
     * 红包金额 单位:分
     */
    private Integer redAmount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 提交人Id
     */
    private Long submitterId;

    /**
     * 提交人姓名
     */
    private String submitterName;

    /**
     * 审批人Id
     */
    private Long checkerId;

    /**
     * 审核人
     */
    private String checkerName;

    /**
     * 审核时间
     */
    private Date checkTime;

    /**
     * 审批留言
     */
    private String checkRemark;

    /**
     * 审核状态：1:待审核 2:审核通过 3:审核拒绝
     * {@link cn.com.duiba.kjy.api.enums.bank.direct.red.DirectRedCheckStatus}
     */
    private Integer checkStatus;

    /**
     * 小程序码地址
     */
    private String mpQrcodeUrl;

    /**
     * 领取状态 1-待领取 2-领取中 3-领取成功 4-领取失败 5-过期
     * {@link cn.com.duiba.kjy.api.enums.bank.direct.red.DirectRedReceiveStatus}
     */
    private Integer receiveStatus;

    /**
     * 业务方订单号
     */
    private String bizTradeNo;

    /**
     * 领取人Id
     */
    private Long receiverId;

    /**
     * 领取时间
     */
    private Date receiveTime;

    /**
     * 查看时间
     */
    private Date viewTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}