package cn.com.duiba.kjy.api.enums.dailyPosters;

import java.util.HashMap;
import java.util.Map;

/**
 * @author linjianhui
 * @description 早晚安图库推荐
 * @date 2020/11/13 14:08
 */
public enum RecommendEnum {

    /**
     * 0：未推荐，1:推荐
     */
    NO_RECOMMEND(0, "未推荐"),
    RECOMMEND(1, "推荐"),
    ;

    private Integer code;
    private String desc;

    RecommendEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, RecommendEnum> ENUM_MAP = new HashMap<>();

    static{
        for(RecommendEnum recommendEnum : values()){
            ENUM_MAP.put(recommendEnum.getCode(), recommendEnum);
        }
    }

    public static RecommendEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
