package cn.com.duiba.kjy.api.enums.renew;

/**
 * @author: linjianhui
 * @date: 2020-06-19 11:17
 * @description: 会员剩余有效期所属区间
 */
public enum VipCycleEnum {

    CYCLE_THIRTY_FIFTEEN(30, "30 >= 会员有效期 > 15天"),
    CYCLE_FIFTEEN_TODAY(15, "15 >= 会员有效期 > 1天"),
    CYCLE_TODAY(1, "1 >= 会员有效期 > 0天"),
    EXPIRED_THREE_DAYS(-3, "到期后3天"),
    EXPIRED_FIFTEEN_DAYS(-15, "到期后15天"),
    ;

    VipCycleEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    private Integer code;
    private String desc;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static VipCycleEnum getByCode(Integer code) {
        for (VipCycleEnum enumVal : VipCycleEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }
}
