package cn.com.duiba.kjy.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.company.CompanyContentDto;
import cn.com.duiba.kjy.api.dto.company.ItemCompanyDto;
import cn.com.duiba.kjy.api.params.company.ItemCompanyParam;

import java.util.List;
import java.util.Map;

/**
 * item所属公司
 * @author zhanghuifeng
 * date 2019-04-17-20:44
 */
@AdvancedFeignClient
public interface RemoteItemCompanyService {

    /**
     * 根据item信息查询
     * @param itemId
     * @param itemType
     * @return
     */
    List<ItemCompanyDto> findByItem(Long itemId, Integer itemType);

    /**
     * 根据item信息查询名单
     * @param itemId
     * @param itemType
     * @param listType  名单类型, 1=黑名单,0=白名单
     * @return
     */
    List<ItemCompanyDto> findByParams(Long itemId, Integer itemType,Integer listType);

    /**
     * 根据item信息查询
     * @param companyId
     * @param itemType
     * @return
     */
    List<ItemCompanyDto> findByCompany(Long companyId, Integer itemType);

    /**
     * 根据公司ID获取关联item数
     * @param companyId
     * @return
     */
    int findCountByCompany(Long companyId);

    Map<Long/*contentId*/, List<CompanyContentDto>> findMapByItemIds(Integer itemType, List<Long> itemIdList);

    /**
     * 通过公司id排除黑名单上的素材id
     * @param companyId 公司id
     * @param itemIdList 素材id列表
     * @return 排除黑名单后的素材id
     */
    List<Long> listNotInBlackList(Long companyId, List<Long> itemIdList);

    /**
     * 通过公司id排除不在名单上的素材id
     * @param companyId 公司id
     * @param contentIdList 素材id列表
     * @return 排除黑名单后的素材id
     */
    List<Long> listInWhiteList(Long companyId, List<Long> contentIdList);

    /**
     * 根据入参查询列表
     * @param itemCompanyParam
     * @return
     */
    List<ItemCompanyDto> listByParam(ItemCompanyParam itemCompanyParam);

    void batchInsert(String companyIds, Long itemId, Integer itemType);

    void blackListBatchInsert(String companyIds, Long itemId, Integer itemTye);
}
