package cn.com.duiba.kjy.api.remoteservice.corp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.corp.CorpCompanyDeptDto;

import java.util.List;
import java.util.Map;

/**
 * 企业公司营业部remote
 * @author zhanghuifeng
 * @date 2021/10/28 10:49
 */
@AdvancedFeignClient
public interface RemoteCorpCompanyDeptService {

    /**
     * 根据公司ID查询营业部列表（排除已删除状态）
     * @param companyId 公司ID
     * @return 营业部列表
     */
    List<CorpCompanyDeptDto> listByCompanyId(Long companyId);

    /**
     * 根据营业部ID更新
     * @param dto 营业部信息
     * @return 更新条数
     */
    int update(CorpCompanyDeptDto dto);

    /**
     * 删除营业部（逻辑删除）
     * 如果营业部存在员工，禁止删除
     * @param deptId 营业部ID
     * @return 删除结果
     */
    Boolean delDept(Long deptId);

    /**
     * 根据公司ID和营业部名称查询营业部列表(排除已删除)
     * @param companyId 公司ID
     * @param deptNameList 营业部名称
     * @return 营业部列表
     */
    List<CorpCompanyDeptDto> listByCompanyIdAndNames(Long companyId, List<String> deptNameList);

    /**
     * 批量插入营业部
     * @param list 数据
     * @return map key:deptName value:id
     */
    Map<String,Long> batchInsertReturnMap(List<CorpCompanyDeptDto> list);

    /**
     * 根据营业部ID集合查询营业部列表
     * @param ids 营业部ID集合
     * @return 营业部列表
     */
    List<CorpCompanyDeptDto> listByIds(List<Long> ids);
}
