package cn.com.duiba.kjy.api.remoteservice.corp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.corp.CorpEmployeeStatDto;

import java.util.List;
import java.util.Map;

/**
 * 企业版员工统计 工号维度
 *
 * @author xuzhigang
 * @date 2021/10/29 2:22 下午
 **/
@AdvancedFeignClient
public interface RemoteCorpEmployeeStatService {
    /**
     * 根据工号查询查询
     *
     * @param jobNumber 工号
     * @return 统计信息
     */
    CorpEmployeeStatDto findByJobNumber(Long companyId, String jobNumber);

    /**
     * 根据工号查询活动查看数
     *
     * @param companyId 公司id
     * @param jobNumber 工号
     * @return 活动查看数
     */
    Integer findReadActivityCount(Long companyId, String jobNumber);

    /**
     * 根据工号查询活动查看数
     *
     * @param companyId 公司id
     * @param jobNumbers 工号集合
     * @return 活动查看数
     */
    Map<String, Integer> batchFindReadActivityCount(Long companyId, List<String> jobNumbers);

    /**
     * 更新
     *
     * @param dto 统计数据
     * @return 执行结果
     */
    int update(CorpEmployeeStatDto dto);

    /**
     * 新增
     *
     * @param dto 统计数据
     * @return 执行结果
     */
    int insert(CorpEmployeeStatDto dto);

    /**
     * 批量新增
     *
     * @param dtos 统计数据
     * @return 执行结果
     */
    int batchInsert(List<CorpEmployeeStatDto> dtos);

    /**
     * 根据id增加已读数量
     *
     * @param id        主键id
     * @param incrCount 需要增加的数量
     * @return 执行结果
     */
    boolean incrReadCountById(Long id, Integer incrCount);

    /**
     * 批量根据id增加已读数量
     *
     * @param ids        主键id集合
     * @param incrCount 需要增加的数量
     * @return 执行结果
     */
    boolean batchIncrReadCountById(List<Long> ids, Integer incrCount);

    /**
     * 根据工号增加已读数量
     *
     * @param companyId 公司id
     * @param jobNumber 工号
     * @param incrCount 需要增加的数量
     * @return 执行结果
     */
    boolean incrReadCountByJobNumer(Long companyId, String jobNumber, Integer incrCount);

    /**
     * 批量根据工号增加已读数量
     *
     * @param companyId 公司id
     * @param jobNumbers 工号集合
     * @param incrCount  需要增加的数量
     * @return 执行结果
     */
    boolean batchIncrReadCountByJobNumer(Long companyId, List<String> jobNumbers, Integer incrCount);
}
