package cn.com.duiba.kjy.api.remoteservice.grabmaterial;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.grabmaterial.GrabMaterialDto;
import cn.com.duiba.kjy.api.dto.grabmaterial.GrabMaterialListDto;
import cn.com.duiba.kjy.api.dto.grabmaterial.MaterialContentExtDetailDto;
import cn.com.duiba.kjy.api.params.grabmaterial.GrabMaterialInsertParam;
import cn.com.duiba.kjy.api.params.grabmaterial.GrabMaterialListParam;
import cn.com.duiba.kjy.api.params.grabmaterial.GrabMaterialSearchParam;

import java.util.List;

/**
 * Created by dugq on 2020-03-05.
 * 爬虫素材库
 */
@AdvancedFeignClient
public interface RemoteGrabMaterialService {
    /**
     * 查询素材
     * @param id
     * @return
     */
    GrabMaterialDto selectOne(Long id);

    /**
     * 批量查询
     * @param pojo
     * @return
     */
    List<GrabMaterialDto> selectList(GrabMaterialSearchParam pojo);

    /**
     * 跟新素材
     * @param record
     * @return
     */
    int updateMaterial(GrabMaterialDto record);

    /**
     *查询数量
     * @param pojo
     * @return
     */
    Integer selectCount(GrabMaterialSearchParam pojo);

    /**
     * 新增素材
     * @param param
     * @return
     */
    Long insert(GrabMaterialInsertParam param);

    /**
     * 删除素材
     * @param id
     * @return
     */
    Integer delete(Long id);

    /**
     * 获取爬虫文库列表 管理后台专用
     * @param param
     * @return
     */
    List<GrabMaterialListDto> getGrabContentList(GrabMaterialListParam param);

    /**
     * 获取爬虫文库总数  管理后台专用
     * @param param
     * @return
     */
    Long selectContentCount(GrabMaterialListParam param);

    /**
     * 根据id获取详情
     * @param id
     * @return
     */
    MaterialContentExtDetailDto getInfoById(Long id);
}
