package cn.com.duiba.kjy.api.remoteservice.interaction;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.interaction.UserBlessingDto;
import cn.com.duiba.kjy.api.enums.material.SellerCustomerMaterialTypeEnum;
import cn.com.duiba.kjy.api.params.interaction.UserBlessingSearchParams;

import java.util.List;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/9/10 2:23 PM
 */
@AdvancedFeignClient
public interface RemoteUserBlessingService {

    /**
     * 保存用户领祝福信息
     * @param dto 用户领祝福信息
     * @return 主键
     */
    Long save(UserBlessingDto dto);

    /**
     * 根据访问记录表主键集合查询
     * @param visitIds 访问记录表主键集合
     * @param materialType 资料类型
     * @see cn.com.duiba.kjy.api.enums.material.SellerCustomerMaterialTypeEnum
     * @return 用户领祝福信息列表
     */
    List<UserBlessingDto> findByVisitIdsAndType(List<Long> visitIds, Integer materialType);

    /**
     * 根据转载ID和领祝福用户ID查询
     * @param scId 销售员转载内容ID
     * @param userId 领祝福用户ID
     * @return 用户领祝福信息
     */
    @Deprecated
    UserBlessingDto findByScIdAndUserCache(Long scId, Long userId);


    /**
     * 根据转载ID和互动用户ID 类型
     * @param scId 销售员转载内容ID
     * @param userId 参与互动UserId
     * @param materialType 事件类型  200/-1:中秋戳一下  201:点赞
     * @return 互动信息
     */
    UserBlessingDto findByScIdUserIdAndEventTypeCache(Long scId, Long userId, SellerCustomerMaterialTypeEnum materialType);

    /**
     * 根据条件查询列表
     * @param param
     * @return
     */
    List<UserBlessingDto> findByCondition(UserBlessingSearchParams param);

    /**
     * 获取访问的事件次数
     * @param visitTableIds
     * @param materialType
     * @return
     */
    Map<Long, Integer> getBlessingCount(List<Long> visitTableIds, SellerCustomerMaterialTypeEnum materialType);

    /**
     * 根据visit_id去重的 列表分页查询
     * @param param
     * @return
     */
    List<UserBlessingDto> findListByParam(UserBlessingSearchParams param);

    /**
     * 根据visit_id去重的 列表总数查询
     * @param params
     * @return
     */
    Integer findCountByParam(UserBlessingSearchParams params);

    /**
     * 查询事件总数不去重
     * @param params
     * @return
     */
    Integer countByParam(UserBlessingSearchParams params);

    /**
     * 根据主键查找
     * 销售演示专用
     * @param id
     * @return
     */
    UserBlessingDto findById(Long id);

    /**
     * 根据主键删除
     * @param ids
     * @return
     */
    Integer deleteByIds(List<Long> ids);
}
