package cn.com.duiba.kjy.api.dto.appvideo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 跟拍app版本配置
 * @author kjj mybatis generator 
 * 2021-10-11
 */
@Data
public class AppVideoVersionDto implements Serializable {
    private static final long serialVersionUID = 16339384327013961L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *标题
     * max length = 20
     * not null default = null
     */
    private String title;

    /**
     *
     *描述
     * max length = 255
     * not null default = null
     */
    private String describes;

    /**
     *
     *关联的安卓安装包id
     * not null default = null
     */
    private Long androidPackageId;

    /**
     *
     * ios安装包地址
     * not null default = null
     */
    private String iosPackageUrl;

    /**
     *
     *安装包所属平台1:IOS,2:安卓
     * not null
     */
    private Integer platform;

    /**
     *
     *包名
     * max length = 20
     * not null default = null
     */
    private String packageName;

    /**
     *
     *更新类型1:强制更新,2:非强制更新
     * not null default = 1
     */
    private Integer updateType;

    /**
     *
     *版本更新日期
     * not null default = null
     */
    private Date updateTime;

    /**
     *
     *创建时间
     * not null default = null
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = null
     */
    private Date gmtModified;

    /**
     * 状态0：未发布，1：已发布
     */
    private Integer state;

    /**
     * 版本号
     */
    private String version;
}