package cn.com.duiba.kjy.api.dto.push;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 午间推送内容
 * @author kjj mybatis generator 
 * 2020-01-06
 */
@Data
public class PushContentDto implements Serializable {
    private static final long serialVersionUID = 15783148502675191L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *文章id，对应tb_content.id
     * not null default = null
     */
    private Long contentId;

    /**
     *
     *标题
     * max length = 255
     * not null default = null
     */
    private String title;

    /**
     *
     *描述
     * max length = 255
     */
    private String pushDesc;

    /**
     *
     *缩略图
     * max length = 255
     */
    private String mainImgUrl;

    /**
     *
     *发布时间
     */
    private Date releaseTime;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 推送状态 ：1：等待推送，2：推送成功，3推送失败
     */
    private Integer state;
}