package cn.com.duiba.kjy.api.enums.feedback;

import cn.com.duiba.kjy.api.util.NumberUtil;
import com.google.common.collect.ImmutableMap;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 反馈来源枚举
 *
 * @author xuzhigang
 * @date 2021/7/13 11:22 上午
 **/
@Getter
@AllArgsConstructor
public enum FeedbackSourceEnum {
    CUSTOMER_MESSAGE(1, "客服消息"),

    HOME_ROBOT(2, "机器人"),

    PERSONAL_CENTER(3, "个人中心"),
    ;

    private final Integer source;

    private final String desc;

    private static final ImmutableMap<Integer, FeedbackSourceEnum> map = ImmutableMap.<Integer, FeedbackSourceEnum>builder()
            .put(CUSTOMER_MESSAGE.getSource(), CUSTOMER_MESSAGE)
            .put(HOME_ROBOT.getSource(), HOME_ROBOT)
            .put(PERSONAL_CENTER.getSource(), PERSONAL_CENTER)
            .build();

    /**
     * 根据来源获取枚举
     */
    public static FeedbackSourceEnum getEnumBySource(Integer source) {
        if (NumberUtil.isNullOrLteZero(source)) {
            return null;
        }
        return map.get(source);
    }
}
