package cn.com.duiba.kjy.api.params.timingLottery;

import cn.com.duiba.kjy.api.enums.timingLottery.TimingLotteryRecordOpenTimeSortEnum;
import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2021/1/6 11:32
 * @Description:
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class TimingLotteryListParam extends PageQuery {

    private static final long serialVersionUID = 3771225417087031409L;

    /**
     * 代理人Id
     */
    private Long sellerId;

    /**
     * 筛选类型 1：待开奖 3：已开奖
     * @see cn.com.duiba.kjy.api.enums.timingLottery.TimingLotteryStatusEnum
     */
    private List<Integer> listType;

    /**
     * 根据开奖时间正序还是倒叙  1：正序  2：倒叙
     * @see cn.com.duiba.kjy.api.enums.timingLottery.TimingLotteryRecordOpenTimeSortEnum
     */
    private Integer sort = TimingLotteryRecordOpenTimeSortEnum.ASC.getCode();

}
