package cn.com.duiba.kjy.api.remoteservice.clockin;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.clockin.SellerClockInDayProgressDto;
import cn.com.duiba.kjy.api.params.PageQuery;

import java.util.Date;
import java.util.List;

/**
 * 每日打卡进度
 *
 * @author xuzhigang
 * @date 2021/4/14 2:03 下午
 **/
@AdvancedFeignClient
public interface RemoteSellerClockInDayProgressService {

    /**
     * 分页查询
     * @param clockInProgressId 打卡进度id
     * @param dayStatus 每日打卡状态 可为空 {@link cn.com.duiba.kjy.api.enums.clockin.DailyClockInStatusEnum}
     * @param pageQuery 分页参数
     * @return 每日进度
     */
    List<SellerClockInDayProgressDto> selectByClockInProgressAndStatus(Long clockInProgressId, Integer dayStatus, PageQuery pageQuery);

    /**
     * 根据sellerId和打卡进度id查询当日任务状态
     *
     * @param clockInProgressId 打卡进度id
     * @param date 日期
     * @return 状态 {@link cn.com.duiba.kjy.api.enums.clockin.DailyClockInStatusEnum}
     */
    Integer getDayStatus(Long clockInProgressId, Date date);
}
