package cn.com.duiba.kjy.api.remoteservice.corp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.corp.CorpActivityStatDto;

import java.util.List;

/**
 * 企业版-企业活动统计
 *
 * @author ZhangJun
 * @date 2021/10/31 1:42 下午
 */
@AdvancedFeignClient
public interface RemoteCorpActivityStatService {

    /**
     * 根据活动id查询统计记录
     *
     * @param activityId 活动id
     * @return 统计记录
     */
    CorpActivityStatDto findByActivityId(Long activityId);

    /**
     * 新增活动统计记录
     *
     * @param dto 活动统计
     * @return 执行结果
     */
    boolean insert(CorpActivityStatDto dto);

    /**
     * 增加查看人数
     *
     * @param id           主键id
     * @param incrCheckCount 需要增加的人数
     * @return 执行结果
     */
    boolean incrCheckCountById(Long id, Integer incrCheckCount);

    /**
     * 增加报名人数
     *
     * @param id             主键id
     * @param incrApplyCount 需要增加的人数
     * @return 执行结果
     */
    boolean incrApplyCountById(Long id, Integer incrApplyCount);

    /**
     * 增加查看+报名查看人数
     *
     * @param id             主键id
     * @param incrCheckCount   需要增加的查看人数
     * @param incrApplyCount 需要的报名人数
     * @return 执行结果
     */
    boolean incrCheckAndApplyCountById(Long id, Integer incrCheckCount, Integer incrApplyCount);

    /**
     * 保存或增加活动统计人数
     *
     * @param activityStatDto 活动统计
     * @return 保存结果
     */
    int saveOrPlusCount(CorpActivityStatDto activityStatDto);

    /**
     * 根据主键ID查询活动列表
     * @param ids 主键ID集合
     * @return 活动列表
     */
    List<CorpActivityStatDto> listByIds(List<Long> ids);

    /**
     * 根据活动ID查询活动列表
     * @param activityIds 活动ID集合
     * @return 活动列表
     */
    List<CorpActivityStatDto> listByActivityIds(List<Long> activityIds);

}
