package cn.com.duiba.kjy.api.dto.clockin;

import lombok.Data;

import java.io.Serializable;

/**
 * 打卡规则配置表
 *
 * @author xuzhigang
 */
@Data
public class ClockInRuleConfDto implements Serializable {
    private static final long serialVersionUID = 741046908930165993L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 打卡规则名称
     */
    private String clockInName;

    /**
     * 打卡类型 1-180天打卡
     * @see cn.com.duiba.kjy.api.enums.clockin.ClockInTypeEnum
     */
    private Integer clockInType;

    /**
     * 打卡周期-单位天
     */
    private Integer clockInPeriod;

    /**
     * 需要打卡次数
     */
    private Integer clockInTimes;

    /**
     * 任务奖励
     */
    private String clockInReward;

    /**
     * 奖励类型
     * @see cn.com.duiba.kjy.api.enums.clockin.ClockInRewardTypeEnum
     */
    private Integer clockInRewardType;
}

