package cn.com.duiba.kjy.api.dto.mqmsg;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 公共空间-客户mq消息
 *
 * @author xuzhigang
 * @date 2021/11/2 7:03 下午
 **/
@Data
public class PubUserCustomerMqDto implements Serializable {
    private static final long serialVersionUID = -1761339836653015804L;

    /**
     * 客户来源 1-直播 2-账号
     * {@link cn.com.duiba.kjy.api.enums.corp.CustomerSourceTypeEnum}
     */
    private Integer sourceType;

    /**
     * 操作类型 1-新增或更新 2-删除
     * {@link cn.com.duiba.kjy.api.enums.corp.CustomerOperationTypeEnum}
     */
    private Integer operationType;

    /**
     * 直播客户
     */
    private List<LiveCustomerMqDto> liveList;

    /**
     * 账号客户
     */
    private List<ContentMainCustomerMqDto> contentMainList;
}
