package cn.com.duiba.kjy.api.dto.seller;

import cn.com.duiba.kjy.api.constant.SellerAccessSourceEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 销售员邀请关系
 * @author zhanghuifeng
 */
@Data
public class SellerInvitationDto implements Serializable {

    private static final long serialVersionUID = 190269449656235103L;
    /**
    * 绑定时间
    */
    private Date bindingTime;

    /**
    * 有效截止日期
    */
    private Date protectExpireDate;

    /**
    * 返现状态 0可返现(未返现) 1不可返现(已返现)
     * @see cn.com.duiba.kjy.api.enums.seller.PromotionStateEnum
    */
    private Integer hasPromotion;

    /**
    * 销售员id
    */
    private Long sellerId;

    /**
    * 上级ID(seller_id)
    */
    private Long superiorId;

    /**
     * 客集集来源
     * @see  SellerAccessSourceEnum
     */
    private Integer accessSource;

}

