package cn.com.duiba.kjy.api.enums.crm.contract;

import java.util.HashMap;
import java.util.Map;

/**
 * @author linjianhui
 * @description 付款类型
 * @date 2021/3/16 19:52
 */
public enum CrmContractPaymentTimeEnum {

    /**
     * 付款类型 1：前结 2：后结
     */
    BEFORE_LIVE(1, "前结"),
    AFTER_LIVE(2,"后结"),
    ;

    private Integer code;

    private String desc;

    CrmContractPaymentTimeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, CrmContractPaymentTimeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CrmContractPaymentTimeEnum timeEnum : values()){
            ENUM_MAP.put(timeEnum.getCode(), timeEnum);
        }
    }

    public static CrmContractPaymentTimeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
