package cn.com.duiba.kjy.api.enums.dailyPosters;

import java.util.HashMap;
import java.util.Map;

/**
 * @author linjianhui
 * @description 图库类型
 * @date 2020/11/13 14:08
 */
public enum GalleryTypeEnum {
    /**
     * 图库类型，1：早安图库 2:晚安图库
     */
    GOOD_MORNING(1, "早安图库"),
    GOOD_NIGHT(2, "晚安图库"),
    ;

    private Integer code;

    private String desc;

    GalleryTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, GalleryTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(GalleryTypeEnum galleryTypeEnum : values()){
            ENUM_MAP.put(galleryTypeEnum.getCode(), galleryTypeEnum);
        }
    }

    public static GalleryTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
