package cn.com.duiba.kjy.api.params.clue;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;
import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-12-27 20:46
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ClueSellerConditionParam extends PageQuery {

    private static final long serialVersionUID = 24403188434644149L;

    /**
     * 销售id(必传)
     */
    private Long sellerId;

    /**
     * 上一条线索id
     */
    private Long lastClueId;

    /**
     * 线索类型
     */
    private List<Long> clueTypes;

    /**
     * 访客用户id
     */
    private Long visitorId;

    /**
     * 开始时间
     */
    private Date startDateTime;
}
