package cn.com.duiba.kjy.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.clue.SellerVisitorClueDto;
import cn.com.duiba.kjy.api.params.clue.ClueSellerConditionParam;

import java.util.List;
import java.util.Map;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-12-23 17:15
 * 访客线索service
 */
@AdvancedFeignClient
public interface RemoteSellerVisitorClueService {

    /**
     * 根据线索id查询线索
     *
     * @param clueId 线索id
     * @return 线索详情
     */
    SellerVisitorClueDto findById(Long clueId);


    /**
     * 根据线索id列表查询线索
     *
     * @param clueIds 线索id列表
     * @return 线索列表
     */
    List<SellerVisitorClueDto> listByIds(List<Long> clueIds);

    /**
     * 根据访问id列表查询线索
     *
     * @param visitTableIds 访问id列表
     * @return 线索列表
     */
    List<SellerVisitorClueDto> listByVisitTableIds(List<Long> visitTableIds);

    /**
     * 根据scid统计产生线索的访问数
     * @param scidList 销售素材id列表
     * @return 线索数
     */
    Map<Long, Long> countVisitByScids(List<Long> scidList);

    /**
     * 过滤出有线索的访客id
     * @param scid 销售素材id
     * @param visitorIds 访客id列表
     * @return 有线索的访问id
     */
    List<Long> filterVisitorWithClue(Long scid, List<Long> visitorIds);

    /**
     * 获取每个销售最近的一条线索
     * @param sids 销售id列表
     * @return key：销售id value：最近的一条线索
     */
    Map<Long, SellerVisitorClueDto> findLastClueBySids(List<Long> sids);

    /**
     * 根据销售id和其他参数，瀑布流查询
     * @param clueSellerConditionParam 查询参数
     * @return 线索详情
     */
    List<SellerVisitorClueDto> listBySellerCondition(ClueSellerConditionParam clueSellerConditionParam);

    /**
     * 根据销售id和其他参数，统计线索总数
     * @param clueSellerConditionParam 查询参数
     * @return 线索详情
     */
    Long countBySellerCondition(ClueSellerConditionParam clueSellerConditionParam);

    /**
     * 线索-标记为已跟进
     * @param clueId 访问id
     * @return 标记结果
     */
    boolean followClue(Long clueId);
}
