package cn.com.duiba.kjy.api.remoteservice.redpacket;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.attend.AttendRedTaskDto;
import cn.com.duiba.kjy.api.dto.redpacket.attend.AttendRedResultDto;
import cn.com.duiba.kjy.api.dto.redpacket.attend.AttendRedRuleDto;

import java.util.Map;
import java.util.Set;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-08-27 17:57
 * 签到领红包-任务rpc接口
 */
@AdvancedFeignClient
public interface RemoteAttendRedTaskApiService {

    /**
     * 获取签到领红包-普通规则
     *
     * @return 规则
     */
    AttendRedRuleDto getCommonRule();

    /**
     * 通过sellerId获取签到任务
     * @param sellerId 签到任务
     * @return 签到任务
     */
    AttendRedTaskDto findBySellerId(Long sellerId);

    /**
     * 签到
     * @param sellerId 销售id
     * @return 签到结果
     */
    AttendRedResultDto attend(Long sellerId);

    /**
     * 导入销售人员
     * @param sellerIds 销售ids
     * @return 导入失败的销售id
     */
    Set<Long> importSeller(Set<Long> sellerIds);
}
