package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.SellerLastForwardDto;
import cn.com.duiba.kjy.api.params.seller.SellerLastForwardQueryParam;

import java.util.List;

/**
 * @author liuchao1
 * @date 2020/6/22 15:03
 */
@AdvancedFeignClient
public interface RemoteSellerLastForwardService {

    /**
     * 根据条件分页查询
     * @param param 查询条件
     * @return 直接结果
     */
    List<SellerLastForwardDto> selectList(SellerLastForwardQueryParam param);

    /**
     * 根据条件统计总数
     * @param param 查询条件
     * @return 符合条件的总数
     */
    Integer selectCount(SellerLastForwardQueryParam param);
}
