package cn.com.duiba.kjy.api.enums.clue;

import cn.com.duiba.kjy.api.api.enums.PushEventEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 线索类型
 *
 * @author xuzhigang
 * @date 2021/12/10 2:54 下午
 **/
@Getter
@AllArgsConstructor
public enum ClueBizTypeEnum {
    EXPLOSION_VOTE(1, PushEventEnum.EXPLOSION_VOTE.getEventType(), "种草素材内投票"),
    FAQ_VIEW(2, PushEventEnum.FAQ_VISIT_DETAIL.getEventType(), "faq-查看"),
    FAQ_RECEIVE_DATAGRAM(3, PushEventEnum.FAQ_VISIT_SCAN.getEventType(), "faq-领取资料包"),
    FAQ_EXTRA_ASK(4, PushEventEnum.FAQ_VISIT_ASK_EXTRA.getEventType(), "faq-额外咨询"),
    COMPANY_INSURANCE_RECEIVE(5, PushEventEnum.COMPANY_INSURANCE.getEventType(), "公司赠险-领取"),
    TEST_SUBMIT(6, PushEventEnum.CLUE_ACTIVITY_SUMIT_MATERIAL_3.getEventType(), "测评-提交"),
    TEST_REPORT(7, PushEventEnum.RISK_TEST.getEventType(), "测评-领取报告"),
    INVITATION_LETTER_ACCEPT(8, null, "邀请函-接受邀请"),
    GREETING_CARD_THANKS(9, null, "贺卡-感谢"),
    GREETING_CARD_RED(10, null, "贺卡-红包"),
    GREETING_CARD_GIFT(11, null, "贺卡-礼物"),
    LOTTERY_PARTICIPATE(12, null, "抽奖工具-参与"),
    LOTTERY_WIN(13, null, "抽奖工具-中奖"),
    ;

    /**
     * 线索类型
     */
    private final Integer type;

    /**
     * 线索对应推送事件 没有则不会推送
     * {@link PushEventEnum}
     */
    private final String pushEvent;

    /**
     * 描述
     */
    private final String desc;
}
