package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.ScidUserVisitorNumCountDto;
import cn.com.duiba.kjy.api.dto.TodayVisitDto;
import cn.com.duiba.kjy.api.dto.UsersVisitDto;
import cn.com.duiba.kjy.api.dto.user.ReadDurationUpdateDto;
import cn.com.duiba.kjy.api.dto.user.UserVisitResultDto;
import cn.com.duiba.kjy.api.dto.user.UserVisitTraceDto;
import cn.com.duiba.kjy.api.dto.user.UserVisitorNumBean;
import cn.com.duiba.kjy.api.dto.user.UsersVisitAndTraceDto;
import cn.com.duiba.kjy.api.dto.whosawme.SellerCustomerVisitStatisticsDto;
import cn.com.duiba.kjy.api.dto.whosawme.UserVisitBo;
import cn.com.duiba.kjy.api.dto.whosawme.UserVisitTimesDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.UserVisitParam;
import cn.com.duiba.kjy.api.params.VisitLastParam;
import cn.com.duiba.kjy.api.params.user.PageVisitorIdParam;
import cn.com.duiba.kjy.api.params.user.UserAgentSidParam;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by zhangshun on 2019/2/13.
 */
@AdvancedFeignClient
public interface RemoteUserVisitService {

    /**
     * 保存访问记录
     *
     * @param dto
     * @return
     */
    Long save(UsersVisitDto dto);

    /**
     * 保存访问记录V2
     * @param dto
     * @param userVisitTraceDto
     * @return
     */
    UserVisitResultDto saveV2(UsersVisitDto dto, UserVisitTraceDto userVisitTraceDto);

    /**
     * 根据用户ID和销售员ID查询最后一条记录
     *
     * @param visitId   用户ID
     * @param sellerId 销售员ID
     * @return
     */
    Integer countByUserAndSeller(Long visitId, Long sellerId);

    /**
     * 根据用户ID和销售员ID查询最后一条记录
     *
     * @param visitId   用户ID
     * @param sellerId 销售员ID
     * @param scid     销售员内容ID
     * @return
     */
    UsersVisitDto findLastByScid(Long visitId, Long sellerId, Long scid);

    /**
     * 根据用户ID和销售员ID查询最后一条记录【包含访问链路id】
     *
     * @param visitId   用户ID
     * @param sellerId 销售员ID
     * @param scid     销售员内容ID
     * @return
     */
    UsersVisitAndTraceDto findLastByScidWithTrace(Long visitId, Long sellerId, Long scid);

    /**
     * 获取指定时间内，访客（当前用户）查看过名片的代理人id列表
     * @param param
     * @return
     */
    Page<Long> findSellerIdByVisitId(UserAgentSidParam param);

    /**
     * 查询发布的单篇文章访问总时长
     *
     * @param sellerId 销售id
     * @param scId     销售文章id
     * @return
     */
    Long getTotalReadDuration(Long sellerId, Long scId);

    /**
     * 批量获取每篇文章访问总人数
     * @param scIds
     * @return
     */
    Map<Long, Integer> getReadNumMap(List<Long> scIds);

    TodayVisitDto countTodayBySeller(UserVisitParam param);

    Boolean markVisitAlready(Long sellerId, Integer type);

    Long countTodayVisitor(String openId);

    Integer countVisitBySeller(Long sellerId);

    /**
     * 根据时间区间获取代理人访问人数
     * @param sellerId
     * @return
     */
    Integer countVisitNumByTime(Long sellerId, Date startDate, Date endDate);

    /**
     * 根据代理人Id和客户userId获取总数
     * @param sellerId
     * @param userId
     * @return
     */
    Integer countNumBySellerIdAndUserId(Long sellerId, Long userId);

    /**
     * 列表查询
     * @param param
     * @return
     */
    List<UsersVisitDto> listByParams(UserVisitParam param);

    /**
     * 分页获取代理人最近的访客ID
     * @param param
     * @return
     */
    List<Long> pageVisitorId(PageVisitorIdParam param);

    /**
     * 根据主键标记已读访问
     * @param id
     * @return
     */
    Integer markAlreadyReadById(Long id);

    /**
     * 获取24小时内代理人击败百分比
     * @param sellId
     * @return
     */
    String getSellerBeatPercentage(Long sellId);


    /**
     * 统计代理人 访客访问次数以及访问内容
     */
    List<UserVisitTimesDto> countVisitTimes(Long sid);

    /**
     * 根据userId 获取当前
     * @param visitId
     * @return
     */
    UsersVisitDto getRecentVisitRecordByUserId(Long visitId);

    /**
     * 根据主键搜索访问记录
     * @param ids
     * @return
     */
    List<UsersVisitDto> listByIds(List<Long> ids);

    /**
     * 根据条件找到最近一条访问记录
     * @param param
     * @return
     */
    UsersVisitDto findLastByCondition(VisitLastParam param);
    /**
     * 列表统计
     * @param param
     * @return
     */
    Integer countByParams(UserVisitParam param);

    /**
     * 统计客户访问次数 及最后访问时间数据
     * @param sellerId
     * @param custUserId
     * @return
     */
    UserVisitBo getCustRecentVisitInfo(Long sellerId, Long custUserId);

    /**
     * 代理人访客对应访问次数Map
     * @param sellerId
     * @return
     */
    Map<Long, Integer> findVisitorId2TimesMap(Long sellerId);
    /**
     * 代理人访客对应阅读时长Map
     * @param sellerId
     * @return
     */
    Map<Long, Long> findVisitorId2ReadDurationMap(Long sellerId);

    /**
     * @param depth
     * @return
     */
    Integer updateReadDepth(Long userVisitId, Integer depth);

    /**
     * 根据主键查找单条访问记录
     * @return
     */
    UsersVisitDto findByVisitTableId(Long visitTableId);

	/**
     * 根据访问用户ID和创建时间范围查询，访问的不同代理人数(1分钟缓存)
     * @param visitId
     * @param startTime
     * @return
     */
    long findSellerTotalByVisitIdAndTimeWithCache(Long visitId, Date startTime);

    /**
     * 根据sellerId 统计代理人的分享内容的访问次数
     * @param sellerId
     * @return
     */
    Integer countVisitTimesBySeller(Long sellerId);

    /**
     * 更改为已曝光
     * @param visitTableId
     * @return
     */
    Boolean updateIsExposed(Long visitTableId);

    /**
     * 更改代理人客户所有的曝光
     * @param sellerId
     * @param visitorId
     * @return
     */
    Boolean updateExposedBySidAndVid(Long sellerId, Long visitorId);

    /**
     * 更改访问推送类型
     * @param visitTableId
     * @param pushType
     * @return
     */
    Boolean updatePushType(Long visitTableId, Integer pushType);

    /**
     * 根据主键物理删除
     * 代理人演示专用
     * @param ids
     * @return
     */
    Integer deleteByIds(List<Long> ids);

    /**
     * 根据主键查找
     * @param ids
     * @return
     */
    List<UsersVisitDto> findByIds(List<Long> ids);

    /**
     * 代理人来访次数重排序
     * @param sellerId
     * @param visitorId
     * @return
     */
    Integer resortReadNum(Long sellerId,Long visitorId);

    /**
     * 查询用户的访问统计，包括总访问次数和阅读时长
     * @param sellerId
     * @param visitorId 访客id
     * @return
     */
    SellerCustomerVisitStatisticsDto customerVisitStatistics(Long sellerId , Long visitorId);

    /**
     * 根据scid查询访问人数(去重)
     * @param scids
     * @return
     */
    List<ScidUserVisitorNumCountDto> findVisitorNumByScids(List<Long> scids);

    /**
     * 查询visitTableId上一条访问记录id
     * @param sellerId
     * @param visitorUserId
     * @param visitTableId
     * @return
     */
    Long findPreVisitTableId(Long sellerId, Long visitorUserId, Long visitTableId, String contentType);

    /**
     * 根据代理人id查询scid，根据访问人次倒叙排列并分页
     * @param param 查询参数
     * @return 查询结果
     */
    List<UserVisitorNumBean> findScidOrderByReadNum(UserVisitParam param);

    /**
     * 统计代理人访问记录里面出现过多少篇素材
     * @param sellerId 代理人id
     * @return 素材个数
     */
    Integer countScidBySellerId(Long sellerId);

    /**
     * 根据代理人素材集合获取访问次数
     * @param scids 代理人素材集合
     * @return key:scid value:访问次数
     */
    Map<Long, Integer> getVisitNumByScids(List<Long> scids);

    /**
     * 根据条件查询并按照访问次数排序并分页
     * @param param 查询条件
     * @return 直接结果
     */
    List<UserVisitorNumBean> findOrderByVisitNum(UserVisitParam param);

    /**
     *
     * 查询已经访问过的文章列表
     * @param visitId
     * @param contentIds
     * @return
     */
    List<Long> listByVisitIdAndContentIds(Long visitId , List<Long> contentIds);

    /**
     * 批量更新阅读时长
     * @param readDurationUpdateDtos
     */
    void batchUpdateReadDuration(List<ReadDurationUpdateDto> readDurationUpdateDtos);
}
