package cn.com.duiba.kjy.api.remoteservice.corp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.corp.CorpCompanyBizDto;

import java.util.List;
import java.util.Map;

/**
 * 企业后台-关联业务公司
 *
 * @author ZhangJun
 * @date 2021/10/27 10:35 上午
 */
@AdvancedFeignClient
public interface RemoteCorpCompanyBizService {

    /**
     * 根据公司id查询关联的业务公司
     *
     * @param companyId 公司id
     * @return 关联业务公司列表
     */
    List<CorpCompanyBizDto> listByCompanyId(Long companyId);

    /**
     * 根据公司id查询关联业务类型
     * 管理后台专用
     *
     * @param companyIds 公司id集合
     * @return 公司关联业务类型，key：公司id，value：关联类型集合
     */
    Map<Long, List<Integer>> getBizTypesByCompanyIds(List<Long> companyIds);

    /**
     * 根据公司id和公司类型查询
     *
     * @param companyId 公司id
     * @param bizType 业务类型 {@link cn.com.duiba.kjy.api.enums.corp.CorpCompanyBizTypeEnum}
     * @return 业务信息
     */
    CorpCompanyBizDto findByCompanyIdAndBizType(Long companyId, Integer bizType);

}
