package cn.com.duiba.kjy.api.remoteservice.explosioncontent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.explosionContentQuestion.ExplosionContentQuestionDto;
import cn.com.duiba.kjy.api.dto.explosionContentQuestion.ExplosionContentQuestionRelationDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.explosionContent.AnxietyPageParams;
import cn.com.duiba.kjy.api.params.explosionContent.QAPageQryParams;

import java.util.List;

/**
 * 爆款素材问答服务
 * Created by hong
 * time 2020/1/6 20:28.
 */
@AdvancedFeignClient
public interface RemoteExplosionQuestionService {

    /**
     * 新增互助问答
     *
     * @param dto 互助问答
     * @return 新增结果
     */
    Boolean add(ExplosionContentQuestionDto dto);

    /**
     * 分页查询互助问答
     *
     * @param params 分页查询参数
     * @return 分页查询互助问答
     */
    Page<ExplosionContentQuestionDto> findPageList(QAPageQryParams params);

    /**
     * 关键词检索
     * @param params 关键词
     *
     * @return 检索结果
     */
    Page<ExplosionContentQuestionDto> findPageListLikeQuestionOrAnswer(QAPageQryParams params);

    /**
     * 编辑互助问答
     *
     * @param dto 编辑参数
     * @return 编辑结果
     */
    Boolean update(ExplosionContentQuestionDto dto);

    /**
     * 删除互助问答
     *
     * @param id 删除参数
     * @return 删除结果
     */
    Boolean deleteById(Long id);

    /**
     * 通过问答id查询爆款素材数量
     *
     * @param qaId 问答id
     * @return 互助问答数量
     */
    int findCountByQAid(Long qaId);

    /**
     * 通过文章id查询问答
     *
     * @param contentId 文章id
     * @param personalLetter 私信小助手
     * @return  通过文章id获取
     */
    List<ExplosionContentQuestionDto> getQuestions(Long contentId, Integer personalLetter);

    /**
     * 通过收藏id查询问答
     *
     * @param collectionId 收藏id
     * @return 问答列表
     */
    List<ExplosionContentQuestionDto> getQuestionsByCollectionId(Long collectionId);

    /**
     * 通过问答id查询问答
     *
     * @param id 问答id
     * @return 问答
     */
    ExplosionContentQuestionDto getExplosionQAById(Long id);

    /**
     * 根据爆款素材id查询问答
     *
     * @param explosionId 爆款素材id
     * @return 爆款素材关联数据
     */
    List<ExplosionContentQuestionRelationDto> selectList(Long explosionId);

    /**
     * 根据爆款素材id获取私信小科普id
     *
     * @param explosionId 爆款素材id
     * @return 私信小科普id
     */
    Long getKnowledgeId(Long explosionId);

    /**
     * 根据ids获取FAQ问题
     * @param ids 问题id
     * @return 问题列表
     */
    List<ExplosionContentQuestionDto> listByIds(List<Long> ids);

    /**
     * 根据问题查询建议
     *
     * @param question 问题
     * @return 建议
     */
    String getAdviseByQuestion(String question);

    /**
     * 根据id列表查询问答列表
     *
     * @param ids 问题id
     * @return 文达列表
     */
    List<ExplosionContentQuestionDto> getQuestionListByIdList(List<Long> ids);

    /**
     * 获取最新配置的一条问答
     *
     * @param explosionId 爆款素材id
     * @return 最新问答id
     */
    ExplosionContentQuestionDto getLastestQuestion(Long explosionId);

    /**
     * 获取最新的faq
     *
     * @return faq列表
     */
    List<Long> getLastQuestions(Integer count);

    /**
     * 根据主键增加基础询问值
     *
     * @param id 问答id
     */
    void increaseBaseNum(Long id);


    /**
     * 根据count获取最新的count条记录
     *
     * @param anxietyType 焦虑类型
     * @param count 要取的数据条数
     * @return 问题列表
     */
    List<Long> getLastCountQuestions(Integer anxietyType,Integer count);


    /**
     * 根据焦虑类型获取列表
     *
     * @param anxietyPageParams 焦虑类型分页查询参数
     * @return 问题列表
     */
    Page<ExplosionContentQuestionDto> querypage(AnxietyPageParams anxietyPageParams);

}
