package cn.com.duiba.kjy.api.enums.exclusive;

import com.google.common.collect.Lists;

import java.util.List;
import java.util.Objects;

/**
 * @author zhanghuifeng
 * date 2019-04-29-19:31
 */
public enum ExclusiveAreaItemTypeEnum {

    ARTICLE("article", "文章"),
    POSTER("poster","海报"),
    ACTIVITY("activity", "活动"),
    GAME_ANSWER("game_answer", "趣味测试"),
    GAME_ANIMATION("game_animation", "动画"),
    CUSTOM("custom", "自定义链接"),
    VIDEO("video", "视频"),
    POSTER_TEMPLATE("poster_template", "海报模板"),
    ;
    private String code;

    private String desc;

    ExclusiveAreaItemTypeEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static ExclusiveAreaItemTypeEnum getByCode(String code) {
        for (ExclusiveAreaItemTypeEnum enumVal : ExclusiveAreaItemTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(String code) {
        for (ExclusiveAreaItemTypeEnum enumVal : ExclusiveAreaItemTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    /**
     * 返回除自定义链接外的其它枚举 code值
     * @return
     */
    public static List<String> getNotCustomItemTypes(){
        List<String> resultList = Lists.newArrayList();
        for (ExclusiveAreaItemTypeEnum enumVal : ExclusiveAreaItemTypeEnum.values()) {
            if (!Objects.equals(enumVal.getCode(),CUSTOM.getCode())) {
                resultList.add(enumVal.getCode());
            }
        }
        return resultList;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
