package cn.com.duiba.kjy.api.params.corp;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author: HanYaLun
 * @description: 更新页面隐藏状态
 * @create: 2021-08-24 7:26 下午
 */
@Data
public class ChangePageStateParam implements Serializable {

    private static final long serialVersionUID = 8484672665827792771L;

    /**
     * 主键ID
     */
    private Long id;


    /**
     * 页面状态
     * 是否被隐藏,未隐藏：0，已隐藏：1
     * @see cn.com.duiba.kjy.api.enums.corp.PageVisibleEnum
     */
    private Integer hideState;
}
