package cn.com.duiba.kjy.api.dto.contentarticle;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 运营收藏文章表
 * @author kjj mybatis generator
 * 2019-11-15
 */
@Data
public class AdminArticleCollectionDto implements Serializable {
    private static final long serialVersionUID = 15738120948377756L;

    private Long id;

    /**
     *
     *标题
     */
    private String title;

    /**
     *
     *原文链接
     */
    private String sourceUrl;

    /**
     *
     *定时或者发布过后文章的ID
     */
    private Long contentId;

    /**
     *
     *解析过后在爬虫哭的ID
     */
    private Long grabContentId;


    /**
     * 互动配置ID
     */
    private Long interactionId;

    /**
     *
     *定时开启的时间
     */
    private Date timingOpen;

    /**
     *
     *发布时间
     */
    private Date releaseTime;

    /**
     *
     *原文链接的md5
     */
    private String sourceUrlMd5;

    /**
     *
     *操作人
     */
    private String operator;

    /**
     *
     *状态：0:失败 1:未发布，2:定时中，3:以发布
     */
    private Byte articleStatus;
    /**
     * 是否公用
     */
    private Byte publicly;

    /**
     * 分享配文
     */
    private String shareDocument;

    /**
     *
     *创建时间
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     */
    private Date gmtModified;

    /**
     *
     *首页配图，多图“,”隔开
     */
    private String homeImgUrl;

    /**
     * 排版标签
     */
    private Long composeTag;

    /**
     * 数据标签
     */
    private String dataTag;
    /**
     * 个人观点
     */
    private String viewpoint;
}
