package cn.com.duiba.kjy.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 活动类型
 * @author lizhi
 * @date 2019-06-18
 */
public enum  KjjActivityTypeEnum {
    /**
     * 活动类型
     */
    JIKA("jika", "集卡"),
    PAOJI("paoji", "炮击"),
    ZHUANPAN("zhuanpan", "转盘"),
    COUPON("coupon", "优惠卷");

    private String code;

    private String desc;

    KjjActivityTypeEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    private static final Map<String, KjjActivityTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(KjjActivityTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getCode(), typeEnum);
        }
    }

    public static KjjActivityTypeEnum getByType(String code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
