package cn.com.duiba.kjy.api.remoteservice.appvideo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.appvideo.AppVideoVersionDto;

import java.util.List;

/**
 * @author likui
 * @date 2021/10/11 11:31 上午
 * 跟拍app版本rpc
 **/
@AdvancedFeignClient
public interface RemoteAppVideoVersionApiService {

    /**
     * 获取最新跟拍app最新版本信息
     * @param currentVersion 当前版本号
     * @param platform 安装包所属平台1:IOS,2:安卓
     * @return app最新版本信息
     */
    AppVideoVersionDto getLatestVersionByCurrent(String currentVersion,Integer platform);

    /**
     * 新增版本信息
     * @param versionEntity 版本实体类
     * @return 新增结果
     */
    Long insert(AppVideoVersionDto versionEntity);

    /**
     * 根据分页查询版本信息
     * @param offset 偏移量
     * @param pageSize 每页条数
     * @return 版本信息
     */
    List<AppVideoVersionDto> list(Integer offset,Integer pageSize);

}
