package cn.com.duiba.kjy.api.remoteservice.corp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.corp.CorpPageDto;
import cn.com.duiba.kjy.api.dto.corp.PageInfoDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.corp.ChangePageStateParam;
import cn.com.duiba.kjy.api.params.corp.QueryPageInfoParam;
import cn.com.duiba.kjy.api.params.corp.SavePageInfoParam;

import java.util.List;

/**
 * @author: HanYaLun
 * @description: 企业管理-页面管理
 * @create: 2021-08-24 7:24 下午
 */
@AdvancedFeignClient
public interface RemoteCorpPageService {

    /**
     * 查询页面信息
     *
     * @param param 页面信息
     * @return 页面信息列表
     */
     List<PageInfoDto> selectPageInfo(QueryPageInfoParam param);

    /**
     * 新增或更新页面信息
     *
     * @param param 页面信息
     * @return 是否新增或更新成功
     */
    Integer saveOrUpdatePageInfo(SavePageInfoParam param);

    /**
     * 更改页面隐藏状态
     *
     * @param param 页面信息
     * @return 更新成功的条数
     */
    Integer changePageState(ChangePageStateParam param);

    /**
     * 删除页面状态
     *
     * @param id 页面主键ID
     * @return 是否删除成功
     */
    Integer deletePageById(Long id);

    /**
     * 根据权限id查询可使用的页面列表
     * @param authId 权限id
     * @return 可使用的页面
     */
    List<CorpPageDto> findValidPageByAuthId(Long authId);
}
