package cn.com.duiba.kjy.api.dto.clockin;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 打卡总进度
 *
 * @author xuzhigang
 */
@Data
public class SellerClockInProgressDto implements Serializable {
    private static final long serialVersionUID = -4869037494554049169L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 销售ID
     */
    private Long sellerId;

    /**
     * 打卡规则配置id
     */
    private Long clockInRuleConfId;

    /**
     * 打卡类型 1-180天打卡
     * @see cn.com.duiba.kjy.api.enums.clockin.ClockInTypeEnum
     */
    private Integer clockInType;

    /**
     * 状态 1-进行中 2-完成 3-失败 4-发放奖励中 5-审核 6-发放完成
     * @see cn.com.duiba.kjy.api.enums.clockin.ClockInStatusEnum
     */
    private Integer clockInStatus;

    /**
     * 打卡开始时间
     */
    private Date clockInBeginTime;

    /**
     * 打卡结束时间
     */
    private Date clockInEndTime;

    /**
     * 业务id 业务类型为优惠码时表示tb_promotion_batch.id
     */
    private Long bizId;

    /**
     * 业务来源类型 1-优惠码
     * @see cn.com.duiba.kjy.api.enums.clockin.ClockInBizTypeEnum
     */
    private Integer bizType;

    /**
     * 已打卡次数
     */
    private Integer doneTimes;

    /**
     * 是否删除，1=已删除，0=未删除
     * @see cn.com.duiba.kjy.api.enums.DeletedEnum
     */
    private Integer logicDeleted;
}

