package cn.com.duiba.kjy.api.dto.home;

import lombok.Data;

import java.io.Serializable;

/**
 * @author wangbinbin
 * @create 2020-03-25 17:53
 * @descript 是否需要手动选择公众号dto
 */
@Data
public class SubscriptionArticleChooseDto implements Serializable {

    private static final long serialVersionUID = 5832635798169087813L;
    /**
     * 是否需要选择
     */
    private Boolean isNeedChoose;

    /**
     * 公众号id
     */
    private Long subId;

    /**
     * 是否已经添加
     */
    private Boolean hadAdded;

    /**
     * 获取已添加至公众号列表的dto
     * @return
     */
    public static SubscriptionArticleChooseDto getHasAdded() {
        SubscriptionArticleChooseDto dto = new SubscriptionArticleChooseDto();
        dto.setHadAdded(Boolean.TRUE);
        return dto;
    }

    /**
     * 获取默认需要选择公众号dto
     * @return
     */
    public static SubscriptionArticleChooseDto getDefault() {
        SubscriptionArticleChooseDto dto = new SubscriptionArticleChooseDto();
        dto.setHadAdded(Boolean.FALSE);
        dto.setIsNeedChoose(Boolean.TRUE);
        return dto;
    }

    /**
     * 返回不需要选择公众号dto
     * @param subId
     * @return
     */
    public static SubscriptionArticleChooseDto getNoChooseDto(Long subId) {
        SubscriptionArticleChooseDto dto = new SubscriptionArticleChooseDto();
        dto.setHadAdded(Boolean.FALSE);
        dto.setIsNeedChoose(Boolean.FALSE);
        dto.setSubId(subId);
        return dto;
    }
}
