package cn.com.duiba.kjy.api.enums.crm;

import java.util.HashMap;
import java.util.Map;

/**
 * 销售CRM公司创建类型枚举
 * @author zhanghuifeng
 * date 2020/12/3-17:36
 */
public enum CrmCompanyCreateTypeEnum {

    MANAGER(1, "后台创建"),
    SELLER(2,"销售创建"),
    ;

    private Integer code;
    private String desc;

    CrmCompanyCreateTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, CrmCompanyCreateTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CrmCompanyCreateTypeEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static CrmCompanyCreateTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
